This is the code for PF2LoRA on text classification 
### Abstract
We study the personalized federated fine-tuning task with heterogeneous client data in the context of foundation models, where clients collaboratively fine-tune a foundation model (e.g., BERT, GPT) without sharing their local data, achieving personalized models simultaneously. While recent efforts have applied parameter-efficient fine-tuning techniques like low-rank adaptation (LoRA) or training prompts in federated settings, they often overlook data heterogeneity and model personalization.  The primary challenge is that a single common adapter or prompt learner may not suffice for the diverse data of all clients. To address this issue, we propose PF2LoRA, a new personalized federated fine-tuning algorithm based on a novel \emph{ two-level low rank adaptation framework} on top of LoRA. Given the pretrained foundation model whose weight is frozen, our algorithm aims to learn two levels of adaptation simultaneously: the first level aims to learn a common adapter for all clients, while the second level fosters individual client personalization. This framework explicitly accommodates variations in adapter matrix ranks across clients and introduces minimal additional memory overhead, as the second-level adaptation comprises a small number of parameters compared to the first level. Our experiments on natural language understanding and generation tasks demonstrate that PF2LoRA significantly outperforms existing federated fine-tuning methods.

### Implementation
Our personalized federatad fine-tuning experiment is run on 4 NVIDIA A100 GPU, run the experiment by:

`bash run.sh`

There are several important parameters:
`task`: the name of dataset  
`name_or_path`: the name or path of the pre-trained model
`WORKERS`: world size 
`NUM_GPUS`: the number of gpus
`m`: method name [pf2lora, hetlora]
`rank_mat`: the lora rank of matrix
`rank_max`: r_max for hetlora
`rank_min`:  r_min for hetlora
`lr_B`: the learning rate for the common adapter
`lr_A`: the learning rate for the client-specific adapter
`gamma`: the sparsity parameter for hetlora 
`lamb`: the regularization factor
`com_rounds`: the total communication rounds
`com_interval`: the communication interval
`heteroogeneity` the heteroogeneity level